// Header File
// Created 14/01/2004; 17:06:12
//Gestion des introductions...

//Dessine sprite Font0 dans Buffer IntroBuffer
void Font0_DrawSprite_IntroBuffer (register short x asm("%d0"),
		      register short y asm("%d1"),
		      register short h asm("%d2"),
		      register void *sprite asm("%a1"),
		      register void *dest asm("%a0"));

//Prototypes:		      
void INTRO1_DrawStars (void);

//Buffer Introduction
#define IntroBuffer							BufferMap
#define IntroBuffer_SIZEPLAN		3720
#define IntroBuffer_SIZE				7440

#define BlackIntroBuffer()			memset (IntroBuffer,0xFF,IntroBuffer_SIZE)

//TI92+/V200
static char *Text_Intro0[38]={"A LONG PERIOD OF TIME",
													"",
													"PASSED.....   AND THE",
													"",
													"DIMENSION CONTROLLING",
													"",
													"FORCE \42DOH\42 HAS AGAIN",
													"",
													"COME BACK TO LIFE.",
													"",
													"",
													"",
													"",
													"OCCUPYING THE HUGE",
													"",
													"SPACESHIP \42XORG\42, IT HAS",
													"",
													"ENTERED OUR UNIVERSE FROM",
													"",
													"A DIFFERENT DIMENSION.",
													"",
													"",
													"",
													"",
													"\42MIXTEC\42, ARKANOID TYPE",
													"",
													"SPACESHIP, HAS LAUNCHED THE",
													"",
													"CRAFT \42VAUS2\42 TO MAKE A",
													"",
													"PREEMPTIVE ATTACK ON",
													"",
													"\42XORG\42......",
													"",
													"",
													"",
													""};
													
//TI89
static char *Text_Intro1[41]={"A LONG PERIOD OF",
													"",
													"TIME PASSED.....",
													"",
													"AND THE DIMENSION",
													"",
													"CONTROLLING FORCE",
													"",
													"\42DOH\42 HAS AGAIN",
													"",
													"COME BACK TO LIFE.",
													"",
													"",
													"",
													"OCCUPYING THE HUGE",
													"",
													"SPACESHIP \42XORG\42,",
													"",
													"IT HAS ENTERED OUR",
													"",
													"UNIVERSE FROM",
													"",
													"A DIFFERENT",
													"",
													"",
													"DIMENSION. \42MIXTEC\42,",
													"",
													"ARKANOID TYPE",
													"",
													"SPACESHIP, HAS",
													"",
													"LAUNCHED THE CRAFT",
													"",
													"\42VAUS2\42 TO MAKE",
													"",
													"A PREEMPTIVE ATTACK",
													"",
													"ON \42XORG\42......",
													"",
													"",
													""};

//Table des Sprites SHIP
const unsigned char Table_Intro1_Ship_size [13]={7,7,5,4,4,4,4,4,2,2,4,4,2};
const unsigned char Table_Intro1_Ship_x	[13]={0,0,1,1,1,1,1,1,2,2,1,1,2};

const unsigned char Table_Capx [63]={22,19,16,13,10,8,5,5,6,8,9,11,14,17,21,24,27,30,33,33,42,48,54,56,62,66,70,74,79,84,89,94,98,101,105,110,114,118,114,110,105,101,96,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92};
const unsigned char Table_Capy [63]={23,26,29,33,37,41,45,50,55,59,62,65,68,71,74,77,80,83,86,88,89,89,88,86,83,79,76,73,71,68,66,63,59,55,51,47,44,40,34,28,22,19,21,25,30,36,42,48,54,60,66,72,76,79,82,85,87,88,89,90,91,92,93};
	
//Routines d'criture de textes
//Dessine un caractre du font0					           
void Font0_DrawChar_IntroBuffer (short x, short y, unsigned char nb, void *dest)
{
 	//NULL
  if (nb==32) {
 	  Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [0],dest); return;}
    
  //Guillement (")
  if (nb==34) {
    Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [1],dest); return;}
    
  //Virgule (,)
  if (nb==44) {
    Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [2],dest); return;}
   
  //Point (.)
  if (nb==46) {
    Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [3],dest); return;}
    
  //Chiffres (0-9)
  if ((nb>=48) && (nb<=57)) {
  	Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [nb-44],dest); return;}
    
  //Lettres majuscule (A-Z)	
  if ((nb>=65) && (nb<=90)) {
  	Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [nb-51],dest); return;}
    
  //Lettre minuscule (a-z)	
   if ((nb>=97) && (nb<=122)) {
   Font0_DrawSprite_IntroBuffer (x,y,8,SPRITE_FONT0 [nb-83],dest); return;}
}

//Dessine texte font0
void Font0_DrawString_IntroBuffer (short x, short y, char *string, void *dest)
{
	for (unsigned short i=0; i<strlen (string); i++)
	{
		Font0_DrawChar_IntroBuffer (x,y,*(BYTE*)(string+i),dest);
		x+=8;
	}
}

//Affichage titre
void INTRO_ArkanoidTitle (void)
{
	//Horloge  zro
	delay_1Hz=2;
	
	while (!(_keytest2 (RR_ENTER) || _keytest2 (RR_ENTER1) || _keytest2 (RR_ENTER2)))
	{
		//TI92+/V200
		if (CALCULATOR)
		{
			//Dessine image Title
			DrawFullPicture0 (IMG_IntroTitle0,ScreenBuffer);
		
			//Si delay suprieur  1 seconde afficher
			if (delay_1Hz>1)
			{
				Font0_DrawString_White (181,55,"PUSH",ScreenBuffer);
				Font0_DrawString_White (178,65,"START",ScreenBuffer);
			}
			
			//Si 4 seonces
			if (delay_1Hz>=4) delay_1Hz=0;
		
			//Affichage
			CopyScreenBufferToScreen (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
		}
		//TI89
		else
		{
			//Dessine image Title
			DrawFullPicture1 (IMG_IntroTitle1,ScreenBuffer);
			
			//Si Delay
			if (delay_1Hz>1)
			{
				Font0_DrawString_White (118,40,"PUSH",ScreenBuffer);
				Font0_DrawString_White (115,50,"START",ScreenBuffer);
			}
			
			if (delay_1Hz>=4) delay_1Hz=0;
		
			//Affichage
			CopyScreenBufferToScreen4 (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
		}
	}
}

//Gestion texte dfilant
//Dcalage 1 ligne
void ScrollingIntroBuffer (void)
{
	//LightPlane
	memmove (IntroBuffer,(void *)(IntroBuffer+30),IntroBuffer_SIZEPLAN-30);
	//DarkPlane
	memmove (IntroBuffer+IntroBuffer_SIZEPLAN,(void *)(IntroBuffer+IntroBuffer_SIZEPLAN+30),IntroBuffer_SIZEPLAN-30);
}

void CopyIntroBufferInScreenBuffer (short y, unsigned char h)
{
	//LightPlane
	memcpy ((void *)(ScreenBuffer+((y<<5)-(y<<1))),(void *)(IntroBuffer),h*30);
	//DarkPlane
	memcpy ((void *)(ScreenBuffer+ScreenBuffer_SIZEPLAN+((y<<5)-(y<<1))),(void *)(IntroBuffer+IntroBuffer_SIZEPLAN),h*30);
}


//Introduction0
//Introduction vaisseau et texte dfilant
void INTRO_ShipIntroduction (void)
{
	//Ecran noir
	BlackScreenBuffer (ScreenBuffer);
		
	//TI92+/V200
	if (CALCULATOR)
	{
		//Dessine image
		DrawIntro0_Picture0 (IMG_Introduction0_Picture0,ScreenBuffer);
		//Affichage
		CopyScreenBufferToScreen (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
	}
	//TI89
	else
	{
		//Dessine image
		DrawIntro0_Picture1 (IMG_Introduction0_Picture1,ScreenBuffer);
		//Affichage
		CopyScreenBufferToScreen4 (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
	}
	
	//Efface Buffer tampon Texte dfilant
	BlackIntroBuffer ();
	
	unsigned char ptr_text=0;
	unsigned char ytext=7;
	
	TouchKey=FALSE;
	
	//Attente touche ENTER
	while ((((CALCULATOR) && ptr_text<38) || ((!CALCULATOR) && (ptr_text<41))) && ((!(_keytest2 (RR_ENTER) || _keytest2 (RR_ENTER1) || _keytest2 (RR_ENTER2))) || !TouchKey))
	{
		//TI92+/V200
		if (CALCULATOR)
		{
			ScrollingIntroBuffer ();
			
			if (ytext==7)
			{
				Font0_DrawString_IntroBuffer (5, 42, Text_Intro0 [ptr_text++], IntroBuffer);
				ytext=0;
			}
			else
				ytext++;
		
			CopyIntroBufferInScreenBuffer (0,49);
			//Affichage
			CopyScreenBufferToScreen (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
		}
		//TI89
		else
		{
			ScrollingIntroBuffer ();
			
			if (ytext==7)
			{
				Font0_DrawString_IntroBuffer (1, 25, Text_Intro1 [ptr_text++], IntroBuffer);
				ytext=0;
			}
			else
				ytext++;
		
			CopyIntroBufferInScreenBuffer (0,32);
			//Affichage
			CopyScreenBufferToScreen4 (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
		}
		
		//Temps d'attente
		delay_80Hz=0;
		while (delay_80Hz<5);
		
		if (!(_keytest2 (RR_ENTER) || _keytest2 (RR_ENTER1) || _keytest2 (RR_ENTER2))) TouchKey=TRUE;
	}
}

//Introduction1
//Introduction animations vaisseau et passage racket dans vaisseau DOH
void INTRO_AccessInShip (void)
{
	unsigned char ship=0;
	unsigned char cap_n=0;
	unsigned char explose=0;
	
	unsigned short counter=0;
	
	unsigned char missile=0;
	char missile_step=0;
	
	short MISSILE_X=60;
	short MISSILE_Y=26;
	
	BOOL ShowCap=FALSE;
	BOOL ShowShip=FALSE;
	BOOL ShowExplose=FALSE;
	
	TouchKey=FALSE;
	
	while (!(_keytest2 (RR_ENTER) || _keytest2 (RR_ENTER1) || _keytest2 (RR_ENTER2)) || !TouchKey)
	{
		//Ecran noir
		BlackScreenBuffer (ScreenBuffer);
		
		//Dessine toiles
		INTRO1_DrawStars ();
		
		//Image DOH SHIP
		DrawAbsSprite (0,50,30,78,IMG_Introduction1,ScreenBuffer);
		
		//Pas de sprites, delay d'attente
		if (counter>=5)
		{
			//Dessine vaisseau
			if (ShowShip)
				DrawAbsSprite (4+Table_Intro1_Ship_x [ship],12,Table_Intro1_Ship_size [ship],18,SPRITE_INTRO1_SHIP [ship],ScreenBuffer);
			
			//Dessine explosion
			if (ShowExplose)
				FastGraySprite32_MASK_R (85,90,13,SPRITE_INTRO1_EXPLOSE [explose],ScreenBuffer);
			
			//Dessine capsule
			if (ShowCap) {
				FastGraySprite16_MASK_R (Table_Capx [cap_n],Table_Capy [cap_n],6,SPRITE_INTRO1_SHIP [14],ScreenBuffer);
				cap_n++;
				if (cap_n==63) ShowCap=FALSE;}
				
			//Missile
			if (counter==15) missile_step=1;
			
			//*-*-*-*-*-*-*-*
			//GESTION MISSILE
			//*-*-*-*-*-*-*-*
			if (missile_step!=0)
			{
				missile++;
				
				//Simple direction
				if (missile_step==-1)	{
					MISSILE_X+=4; MISSILE_Y+=8; missile-=2;}	
				
				//Parcours missile et dessine missile
				for (int i=0;i<missile;i++)
					FastGraySprite16_MASK_R (MISSILE_X+(i*4),MISSILE_Y+(i*8),8,SPRITE_INTRO1_SHIP [13],ScreenBuffer);
					
				//Collision missile avec vaisseau	
				if (missile==9)	{
					missile_step=-1;
					ShowExplose=TRUE;}
				
				//Destruction missile	
				if (!missile)
					missile_step=0;
			}
		}
		
		//Affichage
		//TI92+/V200
		if (CALCULATOR) {
			//Affichage
			CopyScreenBufferToScreen (0,0,ScreenBuffer,GetPlane (0),GetPlane (1));
			//Attente
			delay_80Hz=0;
			while (delay_80Hz<5);}
		//TI89
		else {
			//Affichage
			CopyScreenBufferToScreen5 (ScreenBuffer,GetPlane (0),GetPlane (1));
			//Attente
			delay_80Hz=0;
			while (delay_80Hz<3);}
		
		//Image n
		counter++;
		
		//Affiche capsule
		if (counter==10) ShowCap=TRUE;
		
		//Gestion vaisseau
		if (counter==5) ShowShip=TRUE;
		if (counter==(unsigned)((ship*3)+28)) ship++;
		if (ship==13) ShowShip=FALSE;
		
		//Gestion explosion
		if (counter==(unsigned)((explose*4)+28)) explose++;
	
		if (counter==70) explose=6;
		if (counter==(unsigned)(((6-explose)*3)+74)) explose++;
		
		if (explose>9) explose=9;
		
		if (counter==90) return;
		
		if (!(_keytest2 (RR_ENTER) || _keytest2 (RR_ENTER1) || _keytest2 (RR_ENTER2))) TouchKey=TRUE;
	}
}

//Dessine toiles
void INTRO1_DrawStars (void)
{
	EXT_CLRPIX(ScreenBuffer,10,14);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,10,14);
	
	EXT_CLRPIX(ScreenBuffer,20,4);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,20,45);
	
	EXT_CLRPIX(ScreenBuffer,100,24);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,100,24);
	
	EXT_CLRPIX(ScreenBuffer,200,34);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,200,34);
	
	EXT_CLRPIX(ScreenBuffer,221,15);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,221,15);
	
	EXT_CLRPIX(ScreenBuffer,180,10);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,180,10);
	
	EXT_CLRPIX(ScreenBuffer,234,18);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,234,18);
	
	EXT_CLRPIX(ScreenBuffer,80,14);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,80,14);
	
	EXT_CLRPIX(ScreenBuffer,135,17);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,135,17);
	
	EXT_CLRPIX(ScreenBuffer,144,42);
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,144,42);
	
	EXT_CLRPIX(ScreenBuffer,164,34);
	
	EXT_CLRPIX(ScreenBuffer+ScreenBuffer_SIZEPLAN,123,28);
}